-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /
-- \   \   \/     Vendor : Xilinx
--  \   \         Version : 1.6
--  /   /         Application : RocketIO GTX Transceiver Wizard
-- /___/   /\     Filename : gtx_wrapper.vhd
-- \   \  /  \
--  \___\/\___\
--
--
-- Module GTX_WRAPPER (a GTX Wrapper)
-- Generated by Xilinx RocketIO GTX Transceiver Wizard
-- 
-- 
-- (c) Copyright 2008 - 2009 Xilinx, Inc. All rights reserved.
-- 
-- This file contains confidential and proprietary information
-- of Xilinx, Inc. and is protected under U.S. and
-- international copyright and other intellectual property
-- laws.
-- 
-- DISCLAIMER
-- This disclaimer is not a license and does not grant any
-- rights to the materials distributed herewith. Except as
-- otherwise provided in a valid license issued to you by
-- Xilinx, and to the maximum extent permitted by applicable
-- law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
-- WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
-- AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
-- BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
-- INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
-- (2) Xilinx shall not be liable (whether in contract or tort,
-- including negligence, or under any other theory of,
-- liability) for any loss or damage of any kind or nature
-- related to, arising under or in connection with these
-- materials, including for any direct, or any indirect,
-- special, incidental, or consequential loss or damage
-- (including loss of data, profits, goodwill, or any type of
-- loss or damage suffered as a result of any action brought
-- by a third party) even if such damage or loss was
-- reasonably foreseeable or Xilinx had been advised of the
-- possibility of the same.
-- 
-- CRITICAL APPLICATIONS
-- Xilinx products are not designed or intended to be fail-
-- safe, or for use in any application requiring fail-safe
-- performance, such as life-support or safety devices or
-- systems, Class III medical devices, nuclear facilities,
-- applications related to the deployment of airbags, or any
-- other applications that could lead to death, personal
-- injury, or severe property or environmental damage
-- (individually and collectively, "Critical
-- Applications"). Customer assumes the sole risk and
-- liability of any use of Xilinx products in Critical
-- Applications, subject only to applicable laws and
-- regulations governing limitations on product liability.
-- 
-- THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
-- PART OF THIS FILE AT ALL TIMES. 


library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;


--***************************** Entity Declaration ****************************

entity GTX_WRAPPER is
generic
(
    -- Simulation attributes
    WRAPPER_SIM_MODE                : string    := "FAST"; -- Set to Fast Functional Simulation Model
    WRAPPER_SIM_GTXRESET_SPEEDUP    : integer   := 0; -- Set to 1 to speed up sim reset
    WRAPPER_SIM_PLL_PERDIV2         : bit_vector:= x"0d0" -- Set to the VCO Unit Interval time
);
port
(
    
    --_________________________________________________________________________
    --_________________________________________________________________________
    --TILE0  (Location)

    ------------------------ Loopback and Powerdown Ports ----------------------
    TILE0_LOOPBACK0_IN                      : in   std_logic_vector(2 downto 0);
    TILE0_LOOPBACK1_IN                      : in   std_logic_vector(2 downto 0);
    ------------------- Receive Ports - RX Data Path interface -----------------
    TILE0_RXDATA0_OUT                       : out  std_logic_vector(39 downto 0);
    TILE0_RXRESET0_IN                       : in   std_logic;
    TILE0_RXUSRCLK0_IN                      : in   std_logic;
    TILE0_RXUSRCLK1_IN                      : in   std_logic;
    TILE0_RXUSRCLK20_IN                     : in   std_logic;
    TILE0_RXUSRCLK21_IN                     : in   std_logic;
    ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    TILE0_RXN0_IN                           : in   std_logic;
    TILE0_RXN1_IN                           : in   std_logic;
    TILE0_RXP0_IN                           : in   std_logic;
    TILE0_RXP1_IN                           : in   std_logic;
    --------------------- Shared Ports - Tile and PLL Ports --------------------
    TILE0_CLKIN_IN                          : in   std_logic;
    TILE0_GTXRESET_IN                       : in   std_logic;
    TILE0_PLLLKDET_OUT                      : out  std_logic;
    TILE0_REFCLKOUT_OUT                     : out  std_logic;
    TILE0_RESETDONE0_OUT                    : out  std_logic;
    TILE0_RESETDONE1_OUT                    : out  std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    TILE0_TXDATA0_IN                        : in   std_logic_vector(39 downto 0);
    TILE0_TXRESET0_IN                       : in   std_logic;
    TILE0_TXUSRCLK0_IN                      : in   std_logic;
    TILE0_TXUSRCLK1_IN                      : in   std_logic;
    TILE0_TXUSRCLK20_IN                     : in   std_logic;
    TILE0_TXUSRCLK21_IN                     : in   std_logic;
    --------------- Transmit Ports - TX Driver and OOB signalling --------------
    TILE0_TXN0_OUT                          : out  std_logic;
    TILE0_TXN1_OUT                          : out  std_logic;
    TILE0_TXP0_OUT                          : out  std_logic;
    TILE0_TXP1_OUT                          : out  std_logic


);

    attribute X_CORE_INFO : string;
    attribute X_CORE_INFO of GTX_WRAPPER : entity is "gtxwizard_v1_6, Coregen v11.2";

end GTX_WRAPPER;


architecture RTL of GTX_WRAPPER is

--***************************** Signal Declarations *****************************

    -- Channel Bonding Signals
    signal  tile0_rxchbondo0_i   : std_logic_vector(3 downto 0);

    -- CC_2B_1SKP Signals


    -- ground and tied_to_vcc_i signals
    signal  tied_to_ground_i                :   std_logic;
    signal  tied_to_ground_vec_i            :   std_logic_vector(63 downto 0);
    signal  tied_to_vcc_i                   :   std_logic;
    

--*************************** Component Declarations **************************

component GTX_WRAPPER_TILE 
generic
(
    -- Simulation attributes
    TILE_SIM_MODE                : string    := "FAST"; -- Set to Fast Functional Simulation Model
    TILE_SIM_GTXRESET_SPEEDUP    : integer   := 0; -- Set to 1 to speed up sim reset
    TILE_SIM_PLL_PERDIV2         : bit_vector:= x"0d0"; -- Set to the VCO Unit Interval time 

    -- Channel bonding attributes
    TILE_CHAN_BOND_MODE_0        : string    := "OFF";  -- "MASTER", "SLAVE", or "OFF"
    TILE_CHAN_BOND_LEVEL_0       : integer   := 0;     -- 0 to 7. See UG for details
    
    TILE_CHAN_BOND_MODE_1        : string    := "OFF";  -- "MASTER", "SLAVE", or "OFF"
    TILE_CHAN_BOND_LEVEL_1       : integer   := 0      -- 0 to 7. See UG for details
);
port 
(
    ------------------------ Loopback and Powerdown Ports ----------------------
    LOOPBACK0_IN                            : in   std_logic_vector(2 downto 0);
    LOOPBACK1_IN                            : in   std_logic_vector(2 downto 0);
    ------------------- Receive Ports - RX Data Path interface -----------------
    RXDATA0_OUT                             : out  std_logic_vector(39 downto 0);
    RXRESET0_IN                             : in   std_logic;
    RXUSRCLK0_IN                            : in   std_logic;
    RXUSRCLK1_IN                            : in   std_logic;
    RXUSRCLK20_IN                           : in   std_logic;
    RXUSRCLK21_IN                           : in   std_logic;
    ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    RXN0_IN                                 : in   std_logic;
    RXN1_IN                                 : in   std_logic;
    RXP0_IN                                 : in   std_logic;
    RXP1_IN                                 : in   std_logic;
    --------------------- Shared Ports - Tile and PLL Ports --------------------
    CLKIN_IN                                : in   std_logic;
    GTXRESET_IN                             : in   std_logic;
    PLLLKDET_OUT                            : out  std_logic;
    REFCLKOUT_OUT                           : out  std_logic;
    RESETDONE0_OUT                          : out  std_logic;
    RESETDONE1_OUT                          : out  std_logic;
    ------------------ Transmit Ports - TX Data Path interface -----------------
    TXDATA0_IN                              : in   std_logic_vector(39 downto 0);
    TXRESET0_IN                             : in   std_logic;
    TXUSRCLK0_IN                            : in   std_logic;
    TXUSRCLK1_IN                            : in   std_logic;
    TXUSRCLK20_IN                           : in   std_logic;
    TXUSRCLK21_IN                           : in   std_logic;
    --------------- Transmit Ports - TX Driver and OOB signalling --------------
    TXN0_OUT                                : out  std_logic;
    TXN1_OUT                                : out  std_logic;
    TXP0_OUT                                : out  std_logic;
    TXP1_OUT                                : out  std_logic


);
end component;

component CC_2B_1SKP
generic
(
    CC_CHAR                                 : in  std_logic_vector(7 downto 0) := X"1C";
    ALIGN_CHAR                              : in  std_logic_vector(7 downto 0) := X"7C";
    CHAN_BOND_MODE                          : in  string := "OFF";
    ALIGN_PARALLEL_CHECK                    : in  bit := '1';
    USE_AUTORECOVER                         : in  bit := '1';
    FIFO_ALMOST_EMPTY_OFFSET                : in  bit_vector := X"005";
    FIFO_ALMOST_FULL_OFFSET                 : in  bit_vector := X"1F2" --498    
);
port
(
    GT_RXDATA                               : in   std_logic_vector(15 downto 0);
    GT_RXCHARISK                            : in   std_logic_vector(1  downto 0);
    GT_RXCHARISCOMMA                        : in   std_logic_vector(1  downto 0);
    GT_RXRUNDISP                            : in   std_logic_vector(1  downto 0);
    GT_RXNOTINTABLE                         : in   std_logic_vector(1  downto 0);
    GT_RXDISPERR                            : in   std_logic_vector(1  downto 0);
    GT_RXBUFSTATUS                          : in   std_logic_vector(2  downto 0);
    GT_RXCLKCORCNT                          : in   std_logic_vector(2  downto 0);
    GT_RXCHANBONDSEQ                        : in   std_logic;
    GT_RXCHANISALIGNED                      : in   std_logic;
    GT_RXCHANREALIGN                        : in   std_logic;
    GT_RXLOSSOFSYNC                         : in   std_logic_vector(1  downto 0);
    GT_RXVALID                              : in   std_logic;
    GT_RXUSRCLK2                            : in   std_logic;
    USER_RXUSRCLK2                          : in   std_logic;
    RESET                                   : in   std_logic;
    CCI                                     : in   std_logic_vector(6 downto 0);

    USER_RXDATA                             : out  std_logic_vector(15 downto 0);
    USER_RXCHARISK                          : out  std_logic_vector(1 downto 0);
    USER_RXCHARISCOMMA                      : out  std_logic_vector(1 downto 0);
    USER_RXRUNDISP                          : out  std_logic_vector(1 downto 0);
    USER_RXNOTINTABLE                       : out  std_logic_vector(1 downto 0);
    USER_RXDISPERR                          : out  std_logic_vector(1 downto 0);
    USER_RXBUFSTATUS                        : out  std_logic_vector(2 downto 0);
    USER_RXCLKCORCNT                        : out  std_logic_vector(2 downto 0);
    USER_RXCHANBONDSEQ                      : out  std_logic;
    USER_RXCHANISALIGNED                    : out  std_logic;
    USER_RXCHANREALIGN                      : out  std_logic;
    USER_RXLOSSOFSYNC                       : out  std_logic_vector(1 downto 0);
    USER_RXVALID                            : out  std_logic;
    CCO                                     : out  std_logic_vector(6 downto 0)    
);
end component;

--********************************* Main Body of Code**************************

begin                       

    tied_to_ground_i                    <= '0';
    tied_to_ground_vec_i(63 downto 0)   <= (others => '0');
    tied_to_vcc_i                       <= '1';

    --------------------------- Tile Instances  -------------------------------   


    --_________________________________________________________________________
    --_________________________________________________________________________
    --TILE0  (Location)

    tile0_gtx_wrapper_i : GTX_WRAPPER_TILE
    generic map
    (
        -- Simulation attributes
        TILE_SIM_MODE                => WRAPPER_SIM_MODE,
        TILE_SIM_GTXRESET_SPEEDUP    => WRAPPER_SIM_GTXRESET_SPEEDUP,
        TILE_SIM_PLL_PERDIV2         => WRAPPER_SIM_PLL_PERDIV2,

        -- Channel bonding attributes
        TILE_CHAN_BOND_MODE_0        => "OFF",
        TILE_CHAN_BOND_LEVEL_0       => 0,
    
        TILE_CHAN_BOND_MODE_1        => "OFF",
        TILE_CHAN_BOND_LEVEL_1       => 0
    )
    port map
    (
        ------------------------ Loopback and Powerdown Ports ----------------------
        LOOPBACK0_IN                    =>      TILE0_LOOPBACK0_IN,
        LOOPBACK1_IN                    =>      TILE0_LOOPBACK1_IN,
        ------------------- Receive Ports - RX Data Path interface -----------------
        RXDATA0_OUT                     =>      TILE0_RXDATA0_OUT,
        RXRESET0_IN                     =>      TILE0_RXRESET0_IN,
        RXUSRCLK0_IN                    =>      TILE0_RXUSRCLK0_IN,
        RXUSRCLK1_IN                    =>      TILE0_RXUSRCLK1_IN,
        RXUSRCLK20_IN                   =>      TILE0_RXUSRCLK20_IN,
        RXUSRCLK21_IN                   =>      TILE0_RXUSRCLK21_IN,
        ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        RXN0_IN                         =>      TILE0_RXN0_IN,
        RXN1_IN                         =>      TILE0_RXN1_IN,
        RXP0_IN                         =>      TILE0_RXP0_IN,
        RXP1_IN                         =>      TILE0_RXP1_IN,
        --------------------- Shared Ports - Tile and PLL Ports --------------------
        CLKIN_IN                        =>      TILE0_CLKIN_IN,
        GTXRESET_IN                     =>      TILE0_GTXRESET_IN,
        PLLLKDET_OUT                    =>      TILE0_PLLLKDET_OUT,
        REFCLKOUT_OUT                   =>      TILE0_REFCLKOUT_OUT,
        RESETDONE0_OUT                  =>      TILE0_RESETDONE0_OUT,
        RESETDONE1_OUT                  =>      TILE0_RESETDONE1_OUT,
        ------------------ Transmit Ports - TX Data Path interface -----------------
        TXDATA0_IN                      =>      TILE0_TXDATA0_IN,
        TXRESET0_IN                     =>      TILE0_TXRESET0_IN,
        TXUSRCLK0_IN                    =>      TILE0_TXUSRCLK0_IN,
        TXUSRCLK1_IN                    =>      TILE0_TXUSRCLK1_IN,
        TXUSRCLK20_IN                   =>      TILE0_TXUSRCLK20_IN,
        TXUSRCLK21_IN                   =>      TILE0_TXUSRCLK21_IN,
        --------------- Transmit Ports - TX Driver and OOB signalling --------------
        TXN0_OUT                        =>      TILE0_TXN0_OUT,
        TXN1_OUT                        =>      TILE0_TXN1_OUT,
        TXP0_OUT                        =>      TILE0_TXP0_OUT,
        TXP1_OUT                        =>      TILE0_TXP1_OUT

    );







end RTL;
