library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

entity gtx_serdes is

    generic (
        g_SIMULATION : integer := 0);
    port (
        gtx_refclk_i : in  std_logic;
        gtx_reset_i  : in  std_logic;
        gtx_lbena_i  : in  std_logic;
        tx_reset_i   : in  std_logic;
        rx_reset_i   : in  std_logic;
        tx_data_i    : in  std_logic_vector(39 downto 0);
        gtx_rxp_i    : in  std_logic;
        gtx_rxn_i    : in  std_logic;
        gtx_ready_o  : out std_logic;
        tx_usrclk_o  : out std_logic;
        rx_usrclk_o  : out std_logic;
        gtx_refclk_o : out std_logic;
        rx_data_o    : out std_logic_vector(39 downto 0);
        gtx_txp_o    : out std_logic;
        gtx_txn_o    : out std_logic);

end entity gtx_serdes;

architecture rtl of gtx_serdes is

    signal tied_to_ground     : std_logic;
    signal tied_to_ground_vec : std_logic_vector(63 downto 0);
    signal tied_to_vcc        : std_logic;
    signal tied_to_vcc_vec    : std_logic_vector(7 downto 0);

    signal tile0_plllkdet      : std_logic;
    signal tile0_refclkout     : std_logic;
    signal tile0_txreset0      : std_logic;
    signal tile0_rxreset0      : std_logic;
    signal tile0_resetdone0    : std_logic;
    signal tile0_resetdone0_r  : std_logic;
    signal tile0_resetdone0_r2 : std_logic;

    signal tile0_txusrclk0        : std_logic;
    signal tile0_txusrclk20       : std_logic;
    signal refclkout_pll0_locked  : std_logic;
    signal refclkout_pll0_reset   : std_logic;
    signal tile0_refclkout_to_cmt : std_logic;

    signal tile0_loopback0 : std_logic_vector(2 downto 0);

begin  -- architecture rtl

    --  Static signal Assigments
    tied_to_ground     <= '0';
    tied_to_ground_vec <= x"0000000000000000";
    tied_to_vcc        <= '1';
    tied_to_vcc_vec    <= x"ff";
	 gtx_refclk_o <= tile0_refclkout_to_cmt;

    cmp_refclkout_pll0_bufg : BUFG
        port map (
            I => tile0_refclkout,
            O => tile0_refclkout_to_cmt
            );

    refclkout_pll0_reset <= not tile0_plllkdet;
    cmp_refclkout_pll0 : entity work.MGT_USRCLK_SOURCE_PLL
        generic map (
            MULT            => 4,
            DIVIDE          => 1,
            CLK_PERIOD      => 8.33,
            OUT0_DIVIDE     => 4,
            OUT1_DIVIDE     => 2,
            OUT2_DIVIDE     => 1,
            OUT3_DIVIDE     => 1,
            SIMULATION_P    => 0,
            LOCK_WAIT_COUNT => "0010111011100100"
            )
        port map (
            CLK0_OUT       => tile0_txusrclk20,
            CLK1_OUT       => tile0_txusrclk0,
            CLK2_OUT       => open,
            CLK3_OUT       => open,
            CLK_IN         => tile0_refclkout_to_cmt,
            PLL_LOCKED_OUT => refclkout_pll0_locked,
            PLL_RESET_IN   => refclkout_pll0_reset
            );
    tx_usrclk_o <= tile0_txusrclk20;
    rx_usrclk_o <= tile0_txusrclk20;

    -- Hold the TX in reset till the TX user clocks are stable
    tile0_txreset0 <= not refclkout_pll0_locked or tx_reset_i;

    -- Hold the RX in reset till the RX user clocks are stable
    tile0_rxreset0 <= not refclkout_pll0_locked or rx_reset_i;

    -- Set near-end PMA loopback when gtx_lbena_i = '1'
    tile0_loopback0 <= "010" when gtx_lbena_i = '1' else "000";

    cmp_gtx_wrapper : entity work.GTX_WRAPPER
        generic map (
            WRAPPER_SIM_MODE             => "FAST",
            WRAPPER_SIM_GTXRESET_SPEEDUP => g_SIMULATION,
            WRAPPER_SIM_PLL_PERDIV2      => x"0d0"
            )
        port map (
            ------------------------ Loopback and Powerdown Ports ----------------------
            TILE0_LOOPBACK0_IN   => tile0_loopback0,
            TILE0_LOOPBACK1_IN   => tied_to_ground_vec(2 downto 0),
            ------------------- Receive Ports - RX Data Path interface -----------------
            TILE0_RXDATA0_OUT    => rx_data_o,
            TILE0_RXRESET0_IN    => tile0_rxreset0,
            TILE0_RXUSRCLK0_IN   => tile0_txusrclk0,
            TILE0_RXUSRCLK1_IN   => tied_to_ground,
            TILE0_RXUSRCLK20_IN  => tile0_txusrclk20,
            TILE0_RXUSRCLK21_IN  => tied_to_ground,
            ------- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
            TILE0_RXN0_IN        => gtx_rxn_i,
            TILE0_RXN1_IN        => tied_to_ground,
            TILE0_RXP0_IN        => gtx_rxp_i,
            TILE0_RXP1_IN        => tied_to_ground,
            --------------------- Shared Ports - Tile and PLL Ports --------------------
            TILE0_CLKIN_IN       => gtx_refclk_i,
            TILE0_GTXRESET_IN    => gtx_reset_i,
            TILE0_PLLLKDET_OUT   => tile0_plllkdet,
            TILE0_REFCLKOUT_OUT  => tile0_refclkout,
            TILE0_RESETDONE0_OUT => tile0_resetdone0,
            TILE0_RESETDONE1_OUT => open,
            ------------------ Transmit Ports - TX Data Path interface -----------------
            TILE0_TXDATA0_IN     => tx_data_i,
            TILE0_TXRESET0_IN    => tile0_txreset0,
            TILE0_TXUSRCLK0_IN   => tile0_txusrclk0,
            TILE0_TXUSRCLK1_IN   => tied_to_ground,
            TILE0_TXUSRCLK20_IN  => tile0_txusrclk20,
            TILE0_TXUSRCLK21_IN  => tied_to_ground,
            --------------- Transmit Ports - TX Driver and OOB signalling --------------
            TILE0_TXN0_OUT       => gtx_txn_o,
            TILE0_TXN1_OUT       => open,
            TILE0_TXP0_OUT       => gtx_txp_o,
            TILE0_TXP1_OUT       => open
            );

    process(tile0_txusrclk20, tile0_resetdone0)
    begin
        if(tile0_resetdone0 = '0') then
            tile0_resetdone0_r  <= '0' after 1 ns;
            tile0_resetdone0_r2 <= '0' after 1 ns;
        elsif(tile0_txusrclk20'event and tile0_txusrclk20 = '1') then
            tile0_resetdone0_r  <= tile0_resetdone0   after 1 ns;
            tile0_resetdone0_r2 <= tile0_resetdone0_r after 1 ns;
        end if;
    end process;
    gtx_ready_o <= tile0_resetdone0_r2;

end architecture rtl;
