----------------------------------------------------------------------
----                                                              ----
---- GBT-FPGA SERDES Project                               		  ----
----                                                              ----
---- This file is part of the GBT-FPGA Project              	  ----
---- https://espace.cern.ch/GBT-Project/default.aspx              ----
---- https://svn.cern.ch/reps/gbt_fpga 							  ----
----                                                              ----
----------------------------------------------------------------------
----                                                              ----
----                                                              ----
---- This source file may be used and distributed without         ----
---- restriction provided that this copyright statement is not    ----
---- removed from the file and that any derivative work contains  ----
---- the original copyright notice and the associated disclaimer. ----
----                                                              ----
---- This source file is free software; you can redistribute it   ----
---- and/or modify it under the terms of the GNU General          ----
---- Public License as published by the Free Software Foundation; ----
---- either version 2.0 of the License, or (at your option) any   ----
---- later version.                                               ----
----                                                              ----
---- This source is distributed in the hope that it will be       ----
---- useful, but WITHOUT ANY WARRANTY; without even the implied   ----
---- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ----
---- PURPOSE. See the GNU General Public License for more details.----
----                                                              ----
---- You should have received a copy of the GNU General           ----
---- Public License along with this source; if not, download it   ----
---- from http://www.gnu.org/licenses/gpl.txt                     ----
----                                                              ----
---------------------------------------------------------------------- 
---------------------------------------------------------------------------------------------------------------------------------
--  ENTITY				: 	DECODING.VHD		
--  VERSION				:	0.2						
--  VENDOR SPECIFIC?	:	NO
--  FPGA SPECIFIC? 		:   NO
--  SOFTWARE RELEASE	:	QII 9.0 SP2
--  CREATION DATE		:	10/05/2009
--  LAST UPDATE     	:   08/07/2009  
--  AUTHORs				:	Frederic MARIN (CPPM), Sophie BARON (CERN)
--  LANGAGE 			:	VHDL'93
---------------------------------------------------------------------------------------------------------------------------------
--	DESCRIPTION			:	decodes 120 bits and delivers 88 bits (the 4 header bits + 84 user bits).
--						delivers the 84 user bits.
--					
---------------------------------------------------------------------------------------------------------------------------------
--	VERSIONS HISTORY	:
--                      DATE            	VERSION           	AUTHOR		DESCRIPTION
--                      10/05/2009   		0.1                	MARIN   	first .BDF entity definition           
--						08/07/2009			0.2					BARON		conversion to vhdl file, addition of reset input
---------------------------------------------------------------------------------------------------------------------------------


LIBRARY ieee;
USE ieee.std_logic_1164.all; 

LIBRARY work;

---------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

ENTITY Decoding IS 
	PORT
	(
		Clock_40MHz :  	IN  STD_LOGIC;
		DV_In :  		IN  STD_LOGIC;
		Input :  		IN  STD_LOGIC_VECTOR(119 DOWNTO 0);
		--reset :			IN STD_LOGIC; --added for the vhdl version, was not present on the bdf
		DV_Out :  		OUT  STD_LOGIC;
		Output :  		OUT  STD_LOGIC_VECTOR(83 DOWNTO 0)
	);
END Decoding;

---------------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------------

ARCHITECTURE rtl OF Decoding IS 

COMPONENT rsdecoder
	PORT(receivedcode : IN STD_LOGIC_VECTOR(59 DOWNTO 0);
		 correctedmsg : OUT STD_LOGIC_VECTOR(43 DOWNTO 0)
	);
END COMPONENT;

SIGNAL	Corrected_Message :  STD_LOGIC_VECTOR(87 DOWNTO 0);
SIGNAL	Temp_Output :  STD_LOGIC_VECTOR(83 downto 0);
SIGNAL  Reset_N, Temp_DV_Out : std_logic;

---------------------------------------------------------------------------------------------------------------------------------

BEGIN 

--Reset_N <= not Reset;
DV_Out <= Temp_DV_Out;
Output <= Temp_Output;

process (Clock_40MHz)--, Reset_N)
begin
--	if (Reset_N = '0') then
--			Temp_Output <= (others => '0');
--			Temp_DV_Out <= '0';
--	els
	if (rising_edge(Clock_40MHz)) then
			Temp_DV_Out <= DV_In;
			Temp_Output <= Corrected_Message(83 downto 0);
	end if;
end process;

Decoder_119_60 : rsdecoder
PORT MAP(receivedcode => Input(119 DOWNTO 60),
		 correctedmsg => Corrected_Message(87 DOWNTO 44));

Decoder_59_0 : rsdecoder
PORT MAP(receivedcode => Input(59 DOWNTO 0),
		 correctedmsg => Corrected_Message(43 DOWNTO 0));


END rtl;